<?php

$item = null;
$valor = null;

// Obtener datos generales
$contratos = ControladorContratos::ctrMostrarContratos($item, $valor);
$totalContratos = count($contratos);

$cobros = ControladorCobros::ctrMostrarCobros($item, $valor);
$totalCobros = count($cobros);

$servicios = ControladorServicios::ctrMostrarServicios($item, $valor);
$totalServicios = count($servicios);

$personas = ControladorPersonas::ctrMostrarPersonas($item, $valor);
$totalPersonas = count($personas);

// Calcular contratos activos y vencidos
$contratosActivos = 0;
$contratosVencidos = 0;
$ingresosEsteMes = 0;

foreach($contratos as $contrato){
    if($contrato["estado"] == 0){ // Activos
        $contratosActivos++;
    }
}

// Calcular ingresos del mes actual
date_default_timezone_set('America/Bogota');
$mesActual = date('Y-m');
foreach($cobros as $cobro){
    if(date('Y-m', strtotime($cobro["fecha"])) == $mesActual){
        $ingresosEsteMes += floatval($cobro["total"]);
    }
}

?>



<div class="col-lg-3 col-xs-6">

  <div class="small-box bg-aqua">
    
    <div class="inner">
      
      <h3><?php echo number_format($totalContratos); ?></h3>

      <p>Contratos Totales</p>
      <small><?php echo number_format($contratosActivos); ?> activos</small>
    
    </div>
    
    <div class="icon">
      
      <i class="fa fa-book"></i>
    
    </div>
    
    <a href="contratos" class="small-box-footer">
      
      Ver contratos <i class="fa fa-arrow-circle-right"></i>
    
    </a>

  </div>

</div>

<div class="col-lg-3 col-xs-6">

  <div class="small-box bg-green">
    
    <div class="inner">
    
      <h3><?php echo "$" . number_format($ingresosEsteMes); ?></h3>

      <p>Ingresos Este Mes</p>
      <small><?php echo number_format($totalCobros); ?> cobros totales</small>
    
    </div>
    
    <div class="icon">
    
      <i class="ion ion-social-usd"></i>
    
    </div>
    
    <a href="cobros" class="small-box-footer">
      
      Ver cobros <i class="fa fa-arrow-circle-right"></i>
    
    </a>

  </div>

</div>

<div class="col-lg-3 col-xs-6">

  <div class="small-box bg-gray">
    
    <div class="inner">
    
      <h3><?php echo number_format($totalServicios); ?></h3>

      <p>Tipos de Servicios</p>
  
    </div>
    
    <div class="icon">
    
      <i class="fa fa-audio-description"></i>
    
    </div>
    
    <a href="servicios" class="small-box-footer">

      Ver servicios <i class="fa fa-arrow-circle-right"></i>

    </a>

  </div>

</div>

<div class="col-lg-3 col-xs-6">

  <div class="small-box bg-red">
  
    <div class="inner">
    
      <h3><?php echo number_format($totalPersonas); ?></h3>

      <p>Registros de Clientes</p>
    
    </div>
    
    <div class="icon">
      
      <i class="ion ion-ios-people-outline"></i>
    
    </div>
    
    <a href="personas" class="small-box-footer">
      
      Ver clientes <i class="fa fa-arrow-circle-right"></i>
    
    </a>

  </div>

</div>